Attribute VB_Name = "DlgWindowProc"
Private Declare Function ClientToScreen Lib "user32.dll" ( _
     ByVal hwnd As Long, _
     lpPoint As POINTAPI) As Long

Private Declare Function GetCursorPos Lib "user32.dll" ( _
     lpPoint As POINTAPI) As Long

Private Declare Function SetCursorPos Lib "user32.dll" ( _
     ByVal x As Long, _
     ByVal Y As Long) As Long
' ===============================================================================================

Declare Function SetWindowLong Lib "user32" Alias _
    "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex _
    As Long, ByVal dwNewLong As Long) As Long

Declare Function CallWindowProc Lib "user32" Alias _
    "CallWindowProcA" (ByVal lpPrevWndFunc As Long, _
    ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam _
    As Long, ByVal lParam As Long) As Long

Public Const GWL_WNDPROC = -4
Public OldWndProc As Long
' ===============================================================================================

Private Type LVFINDINFO
    flags As Long
    psz As Long
    lParam As Long
    pt As POINTAPI
    vkDirection As Long
End Type

Private Type LVITEM
    mask As Long
    iItem As Long
    iSubItem As Long
    state As Long
    stateMask As Long
    pszText As String
    cchTextMax As Long
    iImage As Long
    lParam As Long
    iIndent As Long
End Type

' ===============================================================================================
Public Declare Function PathFileExists Lib "shlwapi.dll" Alias "PathFileExistsA" ( _
    ByVal pszPath As String) As Long

Public Declare Function PathRemoveFileSpec Lib "shlwapi.dll" Alias "PathRemoveFileSpecA" ( _
    ByVal pszPath As String) As Long

Private Declare Sub PathStripPath Lib "shlwapi.dll" Alias "PathStripPathA" ( _
    ByVal pszPath As String)

Private Declare Function PathIsDirectory Lib "shlwapi.dll" Alias "PathIsDirectoryA" ( _
    ByVal pszPath As String) As Long

Private Const MAX_PATH As Long = 260
' ===============================================================================================

Public Declare Function SetFocus Lib "user32.dll" ( _
     ByVal hwnd As Long) As Long

Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" ( _
    lpvDest As Any, lpvSource As Any, ByVal cbCopy As Long)

Public Declare Function LockWindowUpdate Lib "user32.dll" ( _
    ByVal hwndLock As Long) As Long

Public Function WindowProc(ByVal hwnd As Long, ByVal Msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    Const BN_CLICKED As Long = &H0
    Const BM_GETCHECK As Long = &HF0
    Const BST_CHECKED As Long = &H1
    Const BST_UNCHECKED As Long = &H0
    Const BM_CLICK As Long = &HF5
    
    Const CBN_SELCHANGE As Long = &H1

    Const LVM_FIRST As Long = &H1000
    Const LVM_SETITEMSTATE As Long = (LVM_FIRST + 43&)
    Const LVM_ENSUREVISIBLE As Long = (LVM_FIRST + 19&)
    ' Const LVM_GETITEMCOUNT As Long = (LVM_FIRST + 4&)
    Const LVFI_STRING As Long = &H2
    Const LVFI_WRAP As Long = &H20
    Const LVM_FINDITEM As Long = (LVM_FIRST + 13&)
    Const LVIS_FOCUSED As Long = &H1
    Const LVIS_SELECTED As Long = &H2
    Const LVIF_STATE As Long = &H8
    
    Dim x As Long, retVal As Long, currentState As Long, i As Integer, myButton As TBBUTTON
    Dim stBuff As String, selPath As String, selFile As String
    Dim slvFI As LVFINDINFO, slvParentHwnd As Long, slvItemIndex As Long, slvItem As LVITEM
    Dim sTmp As String, sPath As String, ret As Long, memMouse As POINTAPI
    Dim tNMH As NMHDR, tCDI As NMTBCUSTOMDRAW, ix As Long, iy As Long, tbbi As TBBUTTON, iSize As Long, rc As RECT

    x = CallWindowProc(OldWndProc, hwnd, Msg, wParam, lParam)
    '' Debug.Print Msg
    Select Case Msg
        
        Case WM_NOTIFY
            CopyMemory tNMH, ByVal lParam, Len(tNMH)
            If tNMH.code = NM_CUSTOMDRAW And tNMH.hwndFrom = toolbarHwnd Then
                CopyMemory tCDI, ByVal lParam, Len(tCDI)
                If tCDI.nmCommon.dwItemSpec = IDC_MYBUTTON Then
                    SendMessage toolbarHwnd, TB_GETBUTTON, 1, tbbi
                    iSize = SendMessage(toolbarHwnd, TB_GETBUTTONSIZE, 0, 0)
                    rc.Left = 0: rc.Top = 0
                    rc.Right = LoWord(iSize): rc.Bottom = HiWord(iSize)
                    ix = (tCDI.nmCommon.rc.Right - tCDI.nmCommon.rc.Left - 32) \ 2
                    iy = 2
                    If ix > 0 Then
                        If (tCDI.nmCommon.uItemState And TBSTATE_CHECKED) Then
                            ix = ix + 1
                            iy = iy + 1
                        End If
                        DrawIcon tCDI.nmCommon.hdc, ix, iy, hMyIcon
                    End If
                End If
            End If
            
        Case WM_COMMAND
            '' Debug.Print wParam, LoWord(wParam)
            
            If wParam = IDC_ZIP Then
                ' Debug.Print "ZIP Button pressed"
                
                '   "  ZIP":
                sTmp = String(259, 0)
                ret = SendMessage(GetParent(globalHDlg), CDM_GETFILEPATH, 260, ByVal sTmp)
                
                If ret > 1 Then
                    sPath = Left$(sTmp, ret - 1)
                    If PathIsDirectory(sPath) Then
                        MsgBox "   !", vbCritical, "  ZIP"
                    Else
                        retVal = MsgBox("  " + sPath + "  ZIP-?", vbQuestion + vbYesNo, "")
                        If retVal = vbYes Then
                            ' :
                            ' .................
'''                            Open App.Path + "\temp.zip" For Output As #55
'''                            Print #55,
'''                            Close #55
                            '       ZIP:
                            SetFocus cboTypeHwnd
                            SendKeys "Z"
                        End If
                    End If
                Else
                    MsgBox "   !", vbCritical, "  ZIP"
                End If
            
            ElseIf LoWord(wParam) = IDC_MYBUTTON Then
                ' Debug.Print "MyButton pressed"
                
                '    -   :
                For i = LBound(buttArr) To UBound(buttArr)
                    currentState = SendMessageLong(toolbarHwnd, TB_GETSTATE, buttArr(i), 0)
                    currentState = currentState And (Not TBSTATE_CHECKED)
                    retVal = SendMessageLong(toolbarHwnd, TB_SETSTATE, buttArr(i), currentState)
                Next i
                
                '   ,   CDlg.InitDir:
                LockWindowUpdate cboExHwnd
                SendMessage cboExHwnd, WM_SETTEXT, 0, ByVal CDlg.InitDir
                SetFocus cboExHwnd  ' << !!!        !!!
                '    "":
                retVal = SendMessageLong(openHwnd, BM_CLICK, 0, 0)
                LockWindowUpdate 0&
                
            ElseIf LoWord(wParam) < 0 Then
                ' Debug.Print "Standard button pressed"
                
                '  ( )     - ,  ,   . ,
                '  ( )       CDN_FOLDERCHANGE, 
                '      ,   -
                
                '    ID's    (   ):
                If UBound(buttArr) = 0 Then
                    '     
                    retVal = SendMessage(toolbarHwnd, TB_BUTTONCOUNT, 0, 0)
                    ' Debug.Print "Button count:", retVal
                    ReDim buttArr(1 To retVal - 1)  ' <<   ,   ()
                    For i = LBound(buttArr) To UBound(buttArr)
                        retVal = SendMessage(toolbarHwnd, TB_GETBUTTON, i, myButton) '  ByVal myButton !!!
                        buttArr(i) = myButton.idCommand
                        ' Debug.Print i, buttArr(i)
                    Next i
                End If
                '         (  )
            
            ElseIf HiWord(wParam) = BN_CLICKED Then
                '  ; lParam   :
                
                If lParam = chkView.hwnd Then
                    ' Debug.Print "chkView pressed"
                    
                    currentState = SendMessageLong(chkView.hwnd, BM_GETCHECK, 0, 0)
                    
                    If currentState = BST_CHECKED Then
                        ' Debug.Print "Checked"
                        '     ;      :
                        WriteINIKey "Common", "FitScreen", "1", iniFile
                        CDlg.CenterOnScreen = False
                        CDlg.FitScreen = True
                        GetCursorPos memMouse
                        ScreenToClient chkView.hwnd, memMouse
                        MoveDlg globalHDlg
                        ModifyDlg globalHDlg, False
                        ClientToScreen chkView.hwnd, memMouse
                        SetCursorPos memMouse.x, memMouse.Y
                        
                    ElseIf currentState = BST_UNCHECKED Then
                        ' Debug.Print "UnChecked"
                        '    :
                        WriteINIKey "Common", "FitScreen", "0", iniFile
                        CDlg.CenterOnScreen = True
                        CDlg.FitScreen = False
                        CDlg.RatioX = 1.4  ' <<  800  600
                        CDlg.RatioY = 1.5  ' <<
                        CDlg.Left = 1  ' <<    
                        CDlg.Top = 1   ' <<
                        GetCursorPos memMouse
                        ScreenToClient chkView.hwnd, memMouse
                        MoveDlg globalHDlg
                        ModifyDlg globalHDlg, False
                        ClientToScreen chkView.hwnd, memMouse
                        SetCursorPos memMouse.x, memMouse.Y
                    End If
                
                ElseIf lParam = openHwnd Then
                    ' Debug.Print "OK button pressed"
                    
                ElseIf lParam = cancelHwnd Then
                    ' Debug.Print "CANCEL button pressed"
                    
                    '   rtb -   WM_DESTROY !!!  - .
                    rtb.Locked = False
                    rtb.Text = ""
                    rtb.Locked = True
                    
                    SetWindowLong DlgHwnd, GWL_WNDPROC, OldWndProc
                    Set rtb = Nothing
                    Set comLab = Nothing
                    Set comText = Nothing
                    Set chkView = Nothing
                    Set imgInfo = Nothing
                        
                End If
                
            ElseIf HiWord(wParam) = CBN_SELCHANGE Then
                '      MRU- ; lParam   :
                
                If lParam = cboExHwnd Then
                    ' Debug.Print "ComboBoxEx32: selection changed"
                    '       ;      . ,
                    '   preview   :
                    stBuff = String$(MAX_PATH, vbNullChar)
                    retVal = SendMessage(cboExHwnd, WM_GETTEXT, Len(stBuff), ByVal stBuff)
                    stBuff = Left$(stBuff, retVal)
                    ' Debug.Print "ComboBoxEx32 selection:", stBuff
                    If PathFileExists(stBuff) Then
                        '   -      :
                        selPath = stBuff
                        retVal = PathRemoveFileSpec(selPath)
                        If retVal <> 0 Then
                            ' PathRemoveFileSpec    - ..    :
                            ' Debug.Print "FILE selected"
                            LockWindowUpdate cboExHwnd
                            '  :
                            SendMessage cboExHwnd, WM_SETTEXT, 0, ByVal selPath
                            '    "" (preview     " "):
                            retVal = SendMessageLong(openHwnd, BM_CLICK, 0, 0)
                            '    :
                            SendMessage cboExHwnd, WM_SETTEXT, 0, ByVal stBuff
                            LockWindowUpdate 0&
                            
                            '       SysListView32,     :
                            ' (..        , -)
                            
                            slvParentHwnd = FindWindowEx(DlgHwnd, ByVal 0&, "SHELLDLL_DefView", vbNullString)
                            ' Debug.Print "slvParentHwnd = ", slvParentHwnd
                            slvHwnd = FindWindowEx(slvParentHwnd, ByVal 0&, "SysListView32", vbNullString)
                            ' Debug.Print "slvHwnd = ", slvHwnd
                            
                            '  SysListView32  -        

                            selFile = stBuff
                            PathStripPath selFile
                            selFile = StripNull(selFile) ' <<     
                            ' Debug.Print "selFile = ", selFile

                            With slvFI
                                .flags = LVFI_STRING Or LVFI_WRAP
                                CopyMemory .psz, selFile + vbNullChar, Len(.psz)
                            End With
                            slvItemIndex = SendMessage(slvHwnd, LVM_FINDITEM, -1, slvFI)  ' <<   ByVal slvFI -       !!!
                            ' Debug.Print "Item index:", slvItemIndex
                            
                            '     SysListView32  - , ,  :
                            With slvItem
                                .mask = LVIF_STATE
                                .stateMask = LVIS_FOCUSED Or LVIS_SELECTED
                                .state = &HF ' LVIS_FOCUSED Or LVIS_SELECTED
                            End With
                            retVal = SendMessage(slvHwnd, LVM_SETITEMSTATE, slvItemIndex, slvItem)  ' <<   ByVal slvItem -       !!!
                            retVal = SendMessage(slvHwnd, LVM_ENSUREVISIBLE, slvItemIndex, ByVal 0&)

                        Else
                            ' PathRemoveFileSpec     - ..    :
                            ' Debug.Print "FOLDER selected"
                            LockWindowUpdate cboExHwnd
                            '  :
                            SendMessage cboExHwnd, WM_SETTEXT, 0, ByVal selPath
                            '    "":
                            retVal = SendMessageLong(openHwnd, BM_CLICK, 0, 0)
                            LockWindowUpdate 0&
                        End If
                        
                    Else
                        '   .      ,    :
                        comText.Text = ""
                        rtb.Text = ""
                    End If
                    
                ElseIf lParam = cboHwnd Then
                    ' Debug.Print " ComboBox: selection changed"
                    
                End If
                
            End If
            
        Case Else
            ' 
    End Select
    WindowProc = x
End Function

